---
title: "PolyGlot"
---

# PolyGlot books FAQ

## What a PolyGlot book is

PolyGlot (.bin) books are just a list of all the moves of the book sorted by position. For each move 16 bytes of data are stored:

* An 8-byte hash key represents the position
* a 2-byte integer represents the move, as toSquareNumber + 64*fromSquareNumber + 4096*promotionPiece
* a 2-byte interer known as the weight (determining the relative probability the move will be chosen)
* two 2-byte numbers known as the 'learn fields', only used for 'book learning' (where they hold the number of plays and number of scored half-points)

The hash key is a normal Zobrist XOR key; the list of basis keys can be obtained from the PolyGlot or XBoard source code. The moves are sorted in the order of ascending key (interpreted as unsigned integer).

The promotionPiece is 0 when the move is not a promotion, or 1-4 for N, B, R, Q respectively.

Squares are numbered 0 (for a1) to 63 (h8), with a8 -> 7.

[Source](http://talkchess.com/forum3/viewtopic.php?p=838101#p838101).

See also:

- [PolyGlot book format](http://hgm.nubati.net/book_format.html)
- [PolyGlot program source code](http://winboard.nl/cgi-bin?p=polyglot.git;a=summary)

## How to make a .BIN opening book (for non programmers)

If you have a file with all the lines you want to be in the book, you can load it in WinBoard, and then select "Save Games to Book" from the File menu. The book will be created with the name you specified for the GUI book (in the Common Engine Options dialog). So you better set that to a name that does not exist yet, or the existing book will be overwritten (if you ignore a warning). In the Common Engine options you can also specify the 'Book Depth', i.e. how many moves at the start of the games should be considered.

The 'Save Games to Book" action adds the currently selected games (by default all games, but you can select sub-sets by text matching of the title line, or through position search) to its internal buffer before saving the latter on the file, and it only clears the buffer at the start of a session. So you can combine games from several PGN files by just repeating the procedure (and ignoring the overwrite warning you get after the first time).

The WinBoard game parser is not super fast, so for making extremely large books (millions of games) there probably exist more convenient tools.

In PolyGlot books the weight the moves get is the number of half-points scored with them, and moves with zero weight are not stored in the book. So to make a book with only white moves you should use a set of games all won by white.

Note that you can select all white wins as a subset by making sure the game result is selected as one of the tags presented in Game List (using the View -> Game List Tags dialog), and, with the 'Filter' entry of the Game List, filter on the text '1-0'. Then only white wins from the currently loaded PGN file will be shown in the Game List, and saved in the book. For the black repertoire you then similarly filter on '0-1'.

Note you can always change the weights afterwards with the aid of the Edit Book dialog, to tune the frequecy with which the various main opening lines will be played.

[Source](https://www.talkchess.com/forum/viewtopic.php?p=710911#p710911).

## How to use PolyGlot on the command line

You can compile a PGN file into a binary book using PolyGlot on the
command line. At the moment, only a main (random) book is provided.
It is not yet possible to control opening lines manually. I am
working on it though.

Usage: "polyglot make-book <options>".

"make-book" options are:

- "-pgn"

Name of the input PGN file. PolyGlot should support any
standard-conforming file. Let me know if you encounter a problem.

- "-bin"

Name of the output binary file. I suggest ".bin" as the extension but
in fact PolyGlot does not care.

- "-max-ply" (default: infinite)

How many plies (half moves) to read for each game. E.g. if set to
"20", only the first 10 full moves of each game will be scanned.

- "-min-game" (default: 3)

How many times must a move be played to be kept in the book. In other
words, moves that were played too rarely will be left out. If you
scan full games "2" seems a minimum, but if you selected lines
manually "1" will make sense.

Example: "polyglot make-book -pgn games.pgn -bin book.bin -max-ply 30".

Building a book is usually very fast (a few minutes at most). Note
however that a lot of memory may be required. To reduce memory usage,
select a ply limit.

[Source](https://www.stmintz.com/ccc/index.php?id=456790).
